
import cadquery as cq

# Define the size of the square and the extrusion depth
square_size = 10.0
extrude_depth = 2.0

# Create a workplane
result = cq.Workplane("front")

# Create a square
result = result.rect(square_size, square_size)

# Move to the top of the square and create a right-angle triangle
result = result.moveTo(0, square_size / 2).polyline([(0, square_size / 2), (square_size / 2, square_size / 2), (0, -square_size / 2)])

# Close the sketch and extrude it
result = result.close().extrude(extrude_depth)

# Export the result
result.val().exportStl("Generated.stl")
