
import cadquery as cq

square_size = 10.0  # Side length of the square
extrude_depth = 2.0  # Extrusion depth

# Create a new Workplane object, representing a 3D space in which we will build the shape
result = cq.Workplane("front")

# Draw a rectangle to represent the square
result = result.rect(square_size, square_size)

# Draw the triangle on top of the square
# Move the starting point to the center of the top side of the square
result = result.moveTo(0, square_size / 2)

# Draw the triangle by specifying the vertices relative to the starting point
# The vertices are placed to make right-angle triangle with the legs equal to square_size
result = result.polyline([
    (0, square_size / 2),  # Move up to the top vertex of the triangle
    (square_size / 2, 0),  # Move to the right vertex of the triangle (triangle is symmetric here)
    (0, -square_size / 2)  # Move back down to the base of the triangle, aligning with the square
]).close()  # Close the polyline to form a continuous loop

# Extrude the closed shape to give it a 3D volume
result = result.extrude(extrude_depth)

# Export the model to an STL file
result.val().exportStl("Refine_V_1.stl")
