
import cadquery as cq

# Create a square and extrude it
result = cq.Workplane("XY").rect(10, 10).extrude(1)

# Cut a triangle out of the square
result = result.workplane().moveTo(5, 5).polyline([(0, 5), (5, 0), (0, -5)]).close().cutThruAll()

# Export the result
result.val().exportStl("Generated.stl")
