
import cadquery as cq

# Set points that form a right triangle
points = [(0, 0), (1, 0), (0, 1)]

# Create a right triangle sketch
result = cq.Workplane("XY").polyline(points).close()

# Extrude the triangular sketch marginally by 0.1 units to create a thin 3D object
result = result.extrude(0.1)

# Save the result as an STL file
result.val().exportStl("Refine_V_1.stl")
