
import cadquery as cq

# Define points that clearly form a right triangle
points = [(0, 0), (1, 0), (0, 1)]

# Creating a Workplane to draw the shape
result = cq.Workplane("XY").polyline(points).close()

# Extruding the 2D shape to convert it into a 3D object
result = result.extrude(0.1)

# Export the result to an STL file
result.val().exportStl("Refine_V_2.stl")
