
import cadquery as cq

# Use the same extrusion height for both the base and the smaller square
extrusion_height = 1

# Create the base square and extrude it
base_square = cq.Workplane("XY").rect(10, 10).extrude(extrusion_height)

# Create the smaller square on top of the base square and extrude it
smaller_square = cq.Workplane("XY").workplane(offset=extrusion_height).rect(8, 8).extrude(extrusion_height)

# Union the two shapes to create a single solid object
result = base_square.union(smaller_square)

# Export the result as an STL file
result.val().exportStl("Refine_V_1.stl")
