
import cadquery as cq

extrusion_height = 1

# Create the base square and extrude it
base_square = cq.Workplane("XY").rect(10, 10).extrude(extrusion_height)

# Create the smaller square at the same start level as the base square and extrude it
smaller_square = cq.Workplane("XY").rect(8, 8).extrude(extrusion_height)

# Combine both squares
result = base_square.union(smaller_square)

# Export the final model to an STL file
result.val().exportStl("Refine_V_2.stl")
