
import cadquery as cq

# Define the parameters of the ring
outer_radius = 10.0
inner_radius = 5.0
extrude_length = 20.0

# Create the ring
result = (
    cq.Workplane("XY")
    .circle(outer_radius)
    .circle(inner_radius)
    .extrude(extrude_length)
)

# Export the result
result.val().exportStl("Generated.stl")
