
import cadquery as cq

# Assigning the proper dimensions
block_size = 10.0
block_height = 10.0
pipe_inner_radius = 1.5
pipe_outer_radius = 2.0  # Slightly larger than the inner radius
pipe_height = 9.0

# Creating the main block
result = cq.Workplane("XY").box(block_size, block_size, block_height)

# Cutting a cylindrical hole in the center of the top face of the block
result = result.faces(">Z").workplane().hole(2 * pipe_inner_radius)

# Creating an annulus on the surface and extruding it to the desired height
result = result.faces(">Z").workplane()\
    .circle(pipe_outer_radius).circle(pipe_inner_radius).extrude(pipe_height)

# Saving the output as an STL file
result.val().exportStl("Refine_V_1.stl")
