
import cadquery as cq

# Define the dimensions of the rectangle
length = 60  # Length of the rectangle
width = 30   # Width of the rectangle
thickness = 10  # Thickness of the rectangle

# Define the radius for the filleted edges
fillet_radius = 5

# Create the 3D object
result = (
    cq.Workplane("XY")  # Start a new workplane on the XY plane
    .box(length, width, thickness)  # Create a box with the specified dimensions
    .edges("|Z")  # Select the vertical edges of the box
    .fillet(fillet_radius)  # Apply a fillet with the specified radius to these edges
)

# Show the result in the viewer (This line would typically be used in local installation)
# show_object(result)

# Export the model to an STL file
result.val().exportStl("Refine_V_1.stl")
