
import cadquery as cq

# Adjusted dimensions to emphasize the rectangular shape
length = 80  # increased length
width = 30   # width remains the same
thickness = 10

# Fillet radius remains the same
fillet_radius = 5

# Create the rectangular box with filleted edges
result = (
    cq.Workplane("XY")
    .box(length, width, thickness)  # Create the base box first
    .edges("|Z")  # Select only the vertical edges
    .fillet(fillet_radius)  # Apply fillet to the selected edges
)

# Export the result as an STL file
result.val().exportStl("Refine_V_2.stl")
