
import cadquery as cq
import math

num_points = 5
radius = 10.0

# Increase the sufficiency of the base angle for differentiation in vertices
angle = 2.0 * math.pi / num_points
angle_offset_scaling_factor = 0.15

result = cq.Workplane("XY")

# Start point
pnt = (radius, 0)
result = result.moveTo(*pnt)

for i in range(num_points):
    # Main vertices calculation with varying angles
    next_pnt = (radius * math.cos((i + 1) * angle + i * angle_offset_scaling_factor), 
                radius * math.sin((i + 1) * angle + i * angle_offset_scaling_factor))
    result = result.lineTo(*next_pnt)
    
    # Inner vertices calculation with original calculation adjusted by a smaller angle offset
    inner_pnt = (radius/2 * math.cos((i + 1.5) * angle + i * 0.5 * angle_offset_scaling_factor), 
                 radius/2 * math.sin((i + 1.5) * angle + i * 0.5 * angle_offset_scaling_factor))
    result = result.lineTo(*inner_pnt)

result = result.close().extrude(5.0)

# Saving the refined output
result.val().exportStl("Refine_V_1.stl")
