
import cadquery as cq

# Define dimensions
length = 20.0
width = 10.0
height = 5.0
cylinder_height = 10.0
cylinder_diameter = length / 4.0  # Ensure diameter is 1/4th the length

# Create the rectangular base block
result = cq.Workplane("XY").box(length, width, height)

# Position the circle for the cylinder at the center of the rectangle and extrude it
result = result.faces(">Z").workplane().center(0, 0).circle(cylinder_diameter / 2.0).extrude(cylinder_height)

# Save the output
result.val().exportStl("Refine_V_1.stl")
