
import cadquery as cq

rect_length = 10.0
rect_width = 5.0
trap_height = 5.0
trap_small_base = 5.0
trap_large_base = rect_length  # Ensuring this is the same as the rectangle length
extrude_amount = 20.0

# Creating a workplane to start with and drawing the base rectangle
result = cq.Workplane("front").rect(rect_length, rect_width)

# Moving to the center edge of the rectangle and drawing the trapezoid
result = result.moveTo(0, rect_width / 2)
# To make sure the trapezium is centered, we need to start from half the small_base
result = result.lineTo(trap_large_base / 2, trap_height).lineTo(-trap_large_base / 2, trap_height).close()

# Extruding the combined sketch
result = result.extrude(extrude_amount)

# Saving the output
result.val().exportStl("Refine_V_1.stl")
