
import cadquery as cq

# Parameters
rect_length = 10.0
rect_width = 5.0
trap_height = 5.0
trap_large_base = rect_length
trap_small_base = 5.0
extrude_amount = 20.0

# Calculation for the non-parallel (equal) sides of the trapezium.
# Using Pythagorean theorem to ensure the sides are of equal length.
leg_length = ((trap_large_base / 2 - trap_small_base / 2)**2 + trap_height**2)**0.5

# Creating the base rectangle and moving to the start of the trapezium sketch
result = cq.Workplane("front").rect(rect_length, rect_width)

# Starting trapezium from the centre of rectangle's top edge
result = result.transformed(offset=(0, rect_width / 2, 0))

# Drawing the trapezium
result = result.moveTo(trap_small_base / 2, 0) \
               .lineTo(trap_large_base / 2, trap_height) \
               .lineTo(-trap_large_base / 2, trap_height) \
               .lineTo(-trap_small_base / 2, 0) \
               .close()

# Extruding the sketch
result = result.extrude(extrude_amount)

# Export to STL
result.val().exportStl("Refine_V_2.stl")
