
import cadquery as cq

# Create a cylinder
cylinder = cq.Workplane("XY").circle(10).extrude(20)

# Create a trapezium to cut out from the cylinder
trapezium = (
    cq.Workplane("XY")
    .moveTo(-2, 10)
    .lineTo(2, 10)
    .lineTo(1, 11)
    .lineTo(-1, 11)
    .close()
    .extrude(20)
)

# Cut the trapezium from the cylinder
result = cylinder.cut(trapezium)

result.val().exportStl("Generated.stl")
