
import cadquery as cq

# Create the base rectangle and extrude it to form the primary block
base = cq.Workplane("XY").rect(3, 2).extrude(1)

# Create the cutout rectangle, align it to the upper edge and negatively extrude it
cutout = (
    cq.Workplane("XY")
    .workplane(offset=1)  # Start on the top face of the base block
    .rect(2, 1.33)  # Smaller rectangle dimensions, adjusting alignment
    .translate((0, 0.33))  # Translate to partially overlap the top edge
    .extrude(-1)  # Cutting downwards into the object to form the U-shape
)

# Cut the smaller rectangle out of the base block
result = base.cut(cutout)

# Save the output
result.val().exportStl("Refine_V_1.stl")
