
import cadquery as cq

# Define the dimensions for easier adjustments
length = 3
width = 2
height = 1
cutout_length = length * 2 / 3
cutout_width = width / 2
cutout_height = height / 2

# Create the base U-shaped block
base = cq.Workplane("XY").box(length, width, height)

# Define the cutout, it should be 2/3 the length of the base and centered and connected to the top edge
cutout = (
    cq.Workplane("XY")
    .workplane(offset=height)
    .center(0, -width/2 + cutout_width/2)
    .rect(cutout_length, cutout_width)
    .extrude(-cutout_height)
)

# Cut the smaller rectangle from the base
result = base.cut(cutout)

# Save the modified design
result.val().exportStl("Refine_V_2.stl")
