
import cadquery as cq

# Create the base plate
base_plate = cq.Workplane("XY").box(100, 50, 10)

# Calculate dimensions for the hole that is roughly 1/4th the size of the base plate
hole_width = 100 / 4
hole_height = 50 / 4

# Calculate the position shift to align the hole towards the bottom of the base
# Considering a small gap between the hole and the bottom edge of the base
gap = 5
hole_y_position = -(50 / 2 - hole_height / 2 - gap)  # shift up just enough so there's a gap below

# Create and position the hole
hole = (
    base_plate.faces(">Z")  # select the top face of the box to work with
    .workplane(centerOption="CenterOfBoundBox")
    .rect(hole_width, hole_height)
    .extrude(-10, combine=False)  # extrusion depth and not combining with base_plate
    .translate((0, hole_y_position, 0))  # translate in Y-direction
)

# Resulting object with hole cut out
result = base_plate.cut(hole)

# Export the STL file
result.val().exportStl("Refine_V_1.stl")
