
import cadquery as cq

# Define the original plate dimensions
plate_length = 100
plate_width = 50
plate_thickness = 10

# Create the base plate
base_plate = cq.Workplane("XY").box(plate_length, plate_width, plate_thickness)

# Calculate the hole dimensions based on 1/4th the size of the plate
hole_length = plate_length / 4
hole_width = plate_width / 4

# Small gap between the bottom of the rectangle and bottom of the original rectangle
gap = 5
hole_y_position = -(plate_width / 2 - hole_width / 2 - gap)

# Create a hole by negatively extruding the smaller rectangular sketch
hole = (
    base_plate.faces(">Z")
    .workplane(centerOption="CenterOfBoundBox")
    .rect(hole_length, hole_width)
    .extrude(-plate_thickness, combine=False)
    .translate((0, hole_y_position, 0))
)

# Combine the base plate and hole to create the final object with the cut
result = base_plate.cut(hole)

# Export result to STL file
result.val().exportStl("Refine_V_2.stl")
