
import cadquery as cq

# Define parameters
outer_radius = 10
inner_radius = 9
angle_degrees = 60
extrude_height = 5

# First, create the outer sector
outer_sector = (
    cq.Workplane("XY")
    .moveTo(0, 0)
    .radiusArc(endPoint=(outer_radius, 0), radius=outer_radius)
    .lineTo(0, 0)
    .close()
    .extrude(extrude_height)
)

# Then create the inner sector
inner_sector = (
    cq.Workplane("XY")
    .moveTo(0, 0)
    .radiusArc(endPoint=(inner_radius, 0), radius=inner_radius)
    .lineTo(0, 0)
    .close()
    .extrude(-extrude_height)  # Negatively extrude to cut out from the original object
)

# Cut the inner sector from the outer sector to create the hollow section
result = outer_sector.cut(inner_sector)

# Export to STL
result.val().exportStl("Refine_V_1.stl")
