
import cadquery as cq

# Dimensions based on descriptions
length = 90.0  # Length of the top
width = 30.0   # Width of the top and depth, as they are the same
thickness = width  # Depth of the top surface as per description

leg_length = 3 * width  # Each leg's length should be 3 times its width
leg_width = width / 3  # Width of each leg
rod_radius = leg_width / 2  # Radius of the rod should be half the width of the legs

# Creating the top surface of the workbench
top = (
    cq.Workplane("front")
    .box(length, width, thickness, centered=(True, True, False))
    .faces(">Z")
    .shell(-0.5 * width)  # Making the top hollow thus cutting a fraction of thickness
)

# Creating the legs of the workbench
leg = (
    cq.Workplane("front")
    .box(leg_width, leg_width, leg_length, centered=(True, True, False))
)

# Positioning the legs under the table top
left_leg = leg.translate((-length / 4, 0, -leg_length / 2))
right_leg = leg.translate((length / 4, 0, -leg_length / 2))

# Creating and positioning the connecting rod
rod_length = 0.5 * length  # Rod extends between the inner faces of the two legs
rod = (
    cq.Workplane("front")
    .circle(rod_radius)
    .extrude(rod_length, combine=True)
    .translate((0, 0, -leg_length + leg_width / 2))
)

# Combining all parts into one workbench object
workbench = top.union(left_leg).union(right_leg).union(rod)

# Saving the model as an STL file
workbench.val().exportStl("Refine_V_1.stl")
