
import cadquery as cq

# Define dimensions
length = 90.0  # Length of the top surface
width = 30.0   # Width of the top surface
thickness = width  # Thickness of the top surface should be equal to the width

# Dimensions for legs
leg_length = 3 * width  # Length of each leg should be 3 times its width
leg_width = width / 3

# Calculating rod dimensions
rod_radius = leg_width / 4  # Slightly less than the width of each leg
rod_length = length * 0.5  # Length of the rod

# Create the top surface of the workbench
top = (
    cq.Workplane("front")
    .box(length, width, thickness, centered=(True, True, False))
    .faces(">Z")  # Select top face
    .shell(-0.1 * width)  # Making the inside of the rectangle hollow
)

# Create a leg
leg = (
    cq.Workplane("front")
    .box(leg_width, leg_width, leg_length, centered=(True, True, False))
)

# Position the legs correctly under the top surface
left_leg = leg.translate((-length / 4, 0, -leg_length / 2))
right_leg = leg.translate((length / 4, 0, -leg_length / 2))

# Create and position the connecting rod
rod = (
    cq.Workplane("front")
    .circle(rod_radius)
    .extrude(rod_length)
    .translate((0, 0, -leg_length + leg_width / 2))
)

# Combine all parts into the final workbench model
workbench = top.union(left_leg).union(right_leg).union(rod)

# Export the model to STL file
workbench.val().exportStl("Refine_V_2.stl")
