
import cadquery as cq

square_size = 10.0
extrusion_height = 5.0
inner_square_size = 8.0
inner_extrusion_height = 4.0

center_circle_diameter = 1.0
center_circle_extrusion_height = 4.5
corner_circle_diameter = 0.5
corner_circle_extrusion_height = 4.75
corner_circle_offset = square_size / 2 - center_circle_diameter  # Adjusted to correctly position the circles near the corners

result = cq.Workplane("XY").box(square_size, square_size, extrusion_height, centered=False)

# Cut the inner square to hollow out the shape
result = result.faces(">Z").workplane().rect(inner_square_size, inner_square_size).cutBlind(-inner_extrusion_height)

# Add a center circle at the bottom of the square
result = result.faces("<Z").workplane(centerOption="CenterOfBoundBox").circle(center_circle_diameter / 2).extrude(center_circle_extrusion_height)

# Add four smaller circles near the corners of the top face of the square
for x in [-1, 1]:
    for y in [-1, 1]:
        result = result.faces(">Z").workplane(centerOption="CenterOfBoundBox").center(
            x * corner_circle_offset, y * corner_circle_offset
        ).circle(corner_circle_diameter / 2).extrude(corner_circle_extrusion_height)

result.val().exportStl("Refine_V_2.stl")
