
import cadquery as cq

# Create a base hexagon and extrude it
result = cq.Workplane("XY").polygon(6, 10.0).extrude(5.0)

# Create a second smaller hexagon on top of the first one and extrude it
result = result.faces(">Z").workplane().polygon(6, 8.0).extrude(4.0)

# Create a third smaller hexagon on top of the second one and extrude it
result = result.faces(">Z").workplane().polygon(6, 6.0).extrude(3.0)

# Create a triangle on the top of the third hexagon and extrude it
result = result.faces(">Z").workplane().polygon(3, 4.0).extrude(2.0)

# Ensure vertices are aligned by rotating each subsequent shape
# It was not explicitly specified how much to rotate, using 30 degrees for the hexagons, and 90 degrees for the triangle as an example
result = cq.Workplane("XY") \
    .polygon(6, 10).extrude(5.0) \
    .faces(">Z").workplane().polygon(6, 8).rotate((0,0,0), (0,0,1), 30).extrude(4.0) \
    .faces(">Z").workplane().polygon(6, 6).rotate((0,0,0), (0,0,1), 30).extrude(3.0) \
    .faces(">Z").workplane().polygon(3, 4).rotate((0,0,0), (0,0,1), 90).extrude(2.0)

# Save the result to an STL file
result.val().exportStl("Refine_V_1.stl")
