
import cadquery as cq

# Creating the base hexagon and extruding it
result = cq.Workplane("XY").polygon(6, 10.0).extrude(5.0)

# Creating a second, smaller hexagon, ensuring vertices start from the right points
result = result.faces(">Z").workplane().polygon(6, 8.0).extrude(4.0)

# Creating a third, even smaller hexagon on top of the second one
result = result.faces(">Z").workplane().polygon(6, 6.0).extrude(3.0)

# Finally, creating a topmost triangle, ensuring it aligns properly with the hexagons below
result = result.faces(">Z").workplane().polygon(3, 4.0).extrude(2.0)

# Exporting the corrected model to an STL file
result.val().exportStl("Refine_V_2.stl")
