
import cadquery as cq

# Creating a heart shape using bezier curves to demonstrate smoother, rounded lobes
heart_shape = (
    cq.Workplane("front")
    .moveTo(0, 0)
    .threePointArc((2, 3), (4, 0))  # Right lobe
    .threePointArc((2, -3), (0, 0)) # Right bottom to center point
    .threePointArc((-2, -3), (-4, 0))  # Left bottom to left lobe
    .threePointArc((-2, 3), (0, 0)) # Complete the left lobe
    .close()  # Close path to form a complete heart shape
)

# Extruding the planar heart shape into 3D object
result = heart_shape.extrude(1)  # The extrusion in one dimension

# Exporting the generated model to an STL file
result.val().exportStl("Refine_V_2.stl")
