
import cadquery as cq

base = 10.0
height = 25.0  # Making sure height is visibly more than twice the base
thickness = 0.5

result = (
    cq.Workplane("front")
    .moveTo(0, 0)
    .lineTo(base, 0)
    .lineTo(0, height)
    .close()
    .offset2D(-thickness)  # Creating an outer border
    .moveTo(0, 0)
    .lineTo(base - thickness, 0)  # Adjusting for thickness to make hollow
    .lineTo(0, height - thickness)
    .close()
    .extrude(thickness)
)

result.val().exportStl("Refine_V_2.stl")
