
import cadquery as cq

# Create a cylinder
cylinder = cq.Workplane("XY").circle(5).extrude(20)

# Create a circle larger than the cylinder's size and place it near the top of the cylinder
circle = cq.Workplane("XY").workplane(offset=18).circle(10).extrude(5)

# Combine the cylinder and the circle
result = cylinder.union(circle)

# Save the output
result.val().exportStl("Generated.stl")
