
import cadquery as cq

# Create a cylinder
cylinder = cq.Workplane("XY").circle(5).extrude(20)

# Create a larger circle near the top of the cylinder and extrude it more noticeably
topFeature = (cq.Workplane("XY")
              .workplane(offset=18)  # Move to the top end of the cylinder
              .circle(12)  # This circle is larger than the cylinder's diameter
              .extrude(5))  # Extrude this circle to form a significant top feature

# Combine the cylinder and the extruded top feature
result = cylinder.union(topFeature)

# Save the output as an STL file
result.val().exportStl("Refine_V_2.stl")
