
import cadquery as cq

length = 100.0
width = 50.0
thickness = 10.0

hole_diameter = 5.0
number_of_holes = 3

# Adjust the hole_spacing_x to space the holes symmetrically from the top left corner
hole_spacing_x = (length / (number_of_holes + 2)) / 2
hole_spacing_y = width / 6  # Positioning nearer the top edge

plate = cq.Workplane("XY").box(length, width, thickness)

# Adjust hole_positions to position the holes closer to the top left corner
hole_positions = [(hole_spacing_x * (1 + i), hole_spacing_y) for i in range(number_of_holes)]

for pos in hole_positions:
    plate = plate.faces(">Z").workplane().pushPoints([pos]).hole(hole_diameter)

plate.val().exportStl("Refine_V_2.stl")
