
import cadquery as cq

# Updated dimensions
table_length = 10.0
horizontal_section_width = 4.0  # Renamed for clarity
table_height = 1.0
column_width = 3.0  # Increased column width
column_height = 4.0

# Create the horizontal section
table_horizontal_section = cq.Workplane("XY").box(table_length, horizontal_section_width, table_height)

# Create the columns
column1 = (
    cq.Workplane("XY")
    .workplane(offset=-column_height)
    .moveTo(-table_length / 2 + column_width / 2, -horizontal_section_width / 2 + column_width / 2)
    .box(column_width, column_width, column_height)
)

column2 = (
    cq.Workplane("XY")
    .workplane(offset=-column_height)
    .moveTo(table_length / 2 - column_width / 2, -horizontal_section_width / 2 + column_width / 2)
    .box(column_width, column_width, column_height)
)

column3 = (
    cq.Workplane("XY")
    .workplane(offset=-column_height)
    .moveTo(-table_length / 2 + column_width / 2, horizontal_section_width / 2 - column_width / 2)
    .box(column_width, column_width, column_height)
)

column4 = (
    cq.Workplane("XY")
    .workplane(offset=-column_height)
    .moveTo(table_length / 2 - column_width / 2, horizontal_section_width / 2 - column_width / 2)
    .box(column_width, column_width, column_height)
)

# Combine all parts and rotate to represent an upside-down table
result = table_horizontal_section.union(column1).union(column2).union(column3).union(column4)
result = result.rotate((0, 0, 0), (1, 0, 0), 180) # Rotate by 180 degrees to make it upside-down

# Export the result as STL
result.val().exportStl("Refine_V_2.stl")
