
import cadquery as cq
import math

base1 = 10.0
base2 = 20.0
height = 15.0
thickness = 5.0

# Calculate the leg's length which should be equal for a regular trapezium
leg_length = math.sqrt((height**2) + ((base2 - base1)/2.0)**2)

# Calculate coordinates of bottom base
x_offset = (base2 - base1) / 2.0

result = (
    cq.Workplane("front")
    .moveTo(-base2 / 2.0, 0)                                # Start at bottom left corner
    .lineTo(-base1 / 2.0 + x_offset, height)                # Top left corner
    .lineTo(base1 / 2.0 + x_offset, height)                 # Top right corner
    .lineTo(base2 / 2.0, 0)                                 # Bottom right corner
    .close()
)

result = result.extrude(thickness)

result.val().exportStl("Refine_V_2.stl")
