
import cadquery as cq

# Create a rectangular sketch and specify dimensions
r = cq.Workplane("front").rect(10, 5)

# Extrude the sketch to create a 3D object
r = r.extrude(2)

# Apply fillets to two corners of the same long edge
r = r.edges("|Z and >X").fillet(1)  # Fillet on one corner
r = r.edges("|Z and <X").fillet(1)  # Fillet on the other corner

# Adding holes closer to the rounded corners
# Revised locations: from (-3, 2) to (-4, 2) and from (3, 2) to (4, 2)
r = r.faces(">Z").workplane().pushPoints([(-4, 2), (4, 2)]).hole(0.5)

# Output the final object to an STL file
r.val().exportStl("Refine_V_1.stl")
