
import cadquery as cq

# Parameters
outer_radius = 10.0
inner_radius = 8.0
height = 20.0
cut_angle = 60.0  # Angle of the cut-out sector

# Create a hollow cylinder
hollow_cylinder = cq.Workplane("XY")\
    .cylinder(height, outer_radius, centered=True)\
    .faces(">Z").shell(-outer_radius+inner_radius) # Apply shell to hollow out

# Create a wedge to cut out
# Correcting the syntax of the wedge function as per the expected parameters (using height and diameter for calculation)
wedge = cq.Workplane("XY")\
    .wedge(height, 2 * outer_radius, 2 * outer_radius, \
           cut_angle / 2, -cut_angle / 2, \
           (0, 0, -height / 2), (0, 0, 1))

# Cut the wedge from the hollow cylinder
cut_pipe = hollow_cylinder.cut(wedge)

# Export the result
cq.exporters.export(cut_pipe, "Refine_V_1.stl")
