
import cadquery as cq

# Adjusting the dimensions based on user feedback
horizontal_length = 2  # shorter horizontal section
vertical_length = 15   # longer vertical section
thickness = 2
curve_radius = 0.5  # subtle curve effect 

# Creating the L-shaped sketch with curved vertical section
result = (cq.Workplane("front")
          # Drawing the longer vertical part with a small curve at the beginning
          .moveTo(0, 0)
          .lineTo(0, curve_radius)
          .threePointArc((curve_radius, curve_radius + curve_radius), (2 * curve_radius, curve_radius))
          .lineTo(thickness + curve_radius, curve_radius)
          .lineTo(thickness, 0)
          .lineTo(thickness, vertical_length - horizontal_length - curve_radius)
          .threePointArc((thickness - curve_radius, vertical_length - horizontal_length),
                          (thickness - 2 * curve_radius, vertical_length - horizontal_length - curve_radius))
          .lineTo(0, vertical_length - horizontal_length - curve_radius)
          .close()
          # Drawing the shorter horizontal part
          .moveTo(thickness, vertical_length - horizontal_length)
          .lineTo(thickness + horizontal_length, vertical_length - horizontal_length)
          .lineTo(thickness + horizontal_length, vertical_length)
          .lineTo(thickness, vertical_length)
          .close()
          .extrude(1)  # Extruding the 2D sketch to create a 3D object
         )

# Exporting as STL
result.val().exportStl("Refine_V_1.stl")
