
import cadquery as cq

# Create a rectangular base block
block = cq.Workplane("XY").rect(20, 10).extrude(5)  # Changed dimensions for clarity, 20 is longer side

# Semi-circle cutout
# Calculating the semi-circle center position to ensure it's on the longer side centered
semi_circle_center_x = 0  # keep it centered on the shorter dimension
semi_circle_center_y = 5 - (5 / 2)  # half way along longer dimension minus radius of the semi-circle
cutout = (
    block.faces(">Z")  # select the top face of the block
    .workplane()
    .center(semi_circle_center_x, semi_circle_center_y)
    .moveTo(0, 0)  # Reset the working plane to ensure the semi-circle is started correctly
    .threePointArc((5, 0), (10, 5))  # Creating semi-circle
    .close()
    .extrude(-5)  # Full depth cut
)

# Exporting to STL
cutout.val().exportStl("Refine_V_1.stl")
