
import cadquery as cq

# Define the dimensions
large_cylinder_radius = 10.0
large_cylinder_height = 20.0
small_cylinder_radius = large_cylinder_radius / 2
small_cylinder_height = 10.0
offset_distance = large_cylinder_radius - small_cylinder_radius

# Create the large cylinder
result = cq.Workplane("XY").circle(large_cylinder_radius).extrude(large_cylinder_height)

# Create the smaller cylinder extruded outwards from the surface of the larger cylinder
result = result.faces(">Z").workplane(centerOption="CenterOfMass").transformed(offset=(offset_distance, 0, 0)).circle(small_cylinder_radius).extrude(small_cylinder_height)

# Export the result as STL
result.val().exportStl("Refine_V_1.stl")
