
import cadquery as cq

large_cylinder_radius = 10.0
large_cylinder_height = 20.0
small_cylinder_radius = large_cylinder_radius / 2
small_cylinder_height = 10.0  # Adjusted height to maintain tiered structure

# Create a large cylinder
result = cq.Workplane("XY").circle(large_cylinder_radius).extrude(large_cylinder_height)

# Add a smaller cylinder tier centered and extruded outward on the top face
result = result.faces(">Z").workplane(centerOption="CenterOfMass").circle(small_cylinder_radius).extrude(small_cylinder_height, combine=True)

result.val().exportStl("Refine_V_2.stl")
