
import cadquery as cq

# Define the dimensions of the table and column width
table_height = 10.0
table_width = 4.0
column_width = 2.0 * table_width   # Columns should be twice the width of the horizontal section
table_thickness = 1.0
hole_diameter = 0.5

# Create the base sketch of the inverted table
sketch = (
    cq.Workplane("front")
    .moveTo(-column_width / 2, 0)
    .lineTo(-column_width / 2, table_height)
    .lineTo(column_width / 2, table_height)
    .lineTo(column_width / 2, 0)
    .lineTo(table_width / 2, 0)
    .lineTo(table_width / 2, table_height - table_thickness)
    .lineTo(-table_width / 2, table_height - table_thickness)
    .lineTo(-table_width / 2, 0)
    .close()
)

# Extrude the sketch to create the basic shape
table = sketch.extrude(table_thickness)

# Create a circular hole in the center of the top surface of the table
table_with_hole = table.faces(">Z").workplane().hole(hole_diameter)

# Output the model to an STL file
table_with_hole.val().exportStl("Refine_V_1.stl")
