
import cadquery as cq

# Define the parameters
table_height = 10.0
table_width = 4.0
column_width = 2.0 * table_width     # Upright columns are twice the width of the horizontal section
table_thickness = 1.0
hole_diameter = 0.5

# Create a "U"-shaped sketch
sketch = (
    cq.Workplane("front")
    .moveTo(-column_width / 2, 0)
    .vLine(table_height)  # Left vertical line
    .hLine(column_width)  # Top horizontal line
    .vLine(-table_height) # Right vertical line
    .hLineTo(table_width / 2)  # Bottom horizontal line (right side)
    .vLine(table_thickness)    # Small vertical line up
    .hLine(-(column_width - table_width))    # Middle horizontal line
    .vLine(-table_thickness)   # Small vertical line down
    .close()
)

# Extrude the "U"-shaped sketch to create the table
table = sketch.extrude(table_thickness)

# Add a hole in the middle of the horizontal surface of the table
table_with_hole = table.faces(">Z").workplane().hole(hole_diameter)

# Export the final model to an STL file
table_with_hole.val().exportStl("Refine_V_2.stl")
