
import cadquery as cq

# Define points to create a proper "L" shape
points = [(0, 0), (0, 10), (2, 10), (2, 2), (10, 2), (10, 0)]

# Create a workplane to draw on
r = cq.Workplane("front").polyline(points)

# Close the polyline to form a sketch, then extrude it
result = r.close().extrude(2)

# Export the model to an STL file
result.val().exportStl("Refine_V_2.stl")
