
import cadquery as cq

# Define the dimensions
rect_length = 30.0
rect_width = 10.0
semi_hex_length = rect_length * 2 / 3
semi_hex_height = rect_width / 2

# Create the rectangle
result = cq.Workplane("front").rect(rect_length, rect_width)

# Create the semi-hexagon
result = result.moveTo(rect_length / 2, rect_width / 2).lineTo(rect_length / 2 + semi_hex_length / 2, rect_width / 2)
result = result.lineTo(rect_length / 2 + semi_hex_length / 2, rect_width / 2 + semi_hex_height)
result = result.lineTo(rect_length / 2 - semi_hex_length / 2, rect_width / 2 + semi_hex_height)
result = result.lineTo(rect_length / 2 - semi_hex_length / 2, rect_width / 2)
result = result.close()

# Extrude the sketch
result = result.extrude(rect_width)

# Export the result
result.val().exportStl("Generated.stl")
