
import cadquery as cq

# Create a base sketch with two overlapping circles of the same radius
result = cq.Workplane("XY").circle(10.0).circle(10.0).extrude(1)

# Move the center of each circle a small distance along the X and Y axis to overlap them properly
result = (cq.Workplane("XY")
          .circle(10.0).moveTo(-5, 0).circle(10.0)  # original circles moved apart
          .extrude(1))

# Create cutout sketch with smaller overlapping circles centered at the same point
cutout = (cq.Workplane("XY").moveTo(-2.5, 0)
          .circle(5.0).moveTo(2.5, 0).circle(5.0)  # smaller circles also moved apart
          .extrude(1))

# Cut the smaller circles from the main shape to create holes
result = result.cut(cutout)

# Save the model as STL
result.val().exportStl("Refine_V_1.stl")
