
import cadquery as cq

# Create a rectangular base object
result = cq.Workplane("XY").rect(10, 2).extrude(0.5)

# Add holes in a triangular formation
result = result.faces(">Z").workplane().pushPoints([(-1, 0), (0.5, -1), (0.5, 1)]).hole(0.2)

# Export the final 3D model to STL
result.val().exportStl("Refine_V_1.stl")
