
import cadquery as cq

# Define dimensions
plate_height = 60.0
plate_width = plate_height * (2 / 3)
plate_thickness = 10.0

slot_width = 5.0
slot_height = plate_height

# Create a rectangular plate
plate = cq.Workplane("front").box(plate_width, plate_height, plate_thickness)

# Create a slot. Ensure it's centered and run through the full thickness of the plate
slot = (cq.Workplane("front")
        .center(0, 0)  # Centering on the front profile
        .rect(slot_width, slot_height)
        .extrude(-plate_thickness))

# Subtract the slot from the plate to create the slotted groove
result = plate.cut(slot)

# Save the result
result.val().exportStl("Refine_V_1.stl")
