
import cadquery as cq

plate_height = 60.0
plate_width = plate_height * (2 / 3)
plate_thickness = 10.0

slot_width = 5.0
slot_height = plate_height

# Create the main plate
plate = cq.Workplane("front").box(plate_width, plate_height, plate_thickness)

# Create the slot. Ensure it's perfectly centered on the plate
slot = (cq.Workplane("front")
         .center(0, 0)  # Center to the middle of the plate
         .rect(slot_width, slot_height)
         .extrude(-plate_thickness))

# Subtract the slot from the plate
result = plate.cut(slot)

# Export the result to an STL file
result.val().exportStl("Refine_V_2.stl")
