
import cadquery as cq

# Define dimensions based on the description
width = 20.0
height = width / 20  # thin rectangle height
square_side = width / 2  # side of the first square
small_square_side = square_side * 0.99  # side of the smaller, top square
extrude_depth = width * 20  # extrusion depth of the object

# Create the base rectangle and extrude it
base = cq.Workplane("front").rect(width, height).extrude(extrude_depth)

# First square on top of the thin rectangle
# Adjusting placement to align bottom right corner with top right of the rectangle
first_square = base.faces(">Z").workplane() \
    .transformed(offset=(width / 4, square_side / 2, 0)) \
    .rect(square_side, square_side).extrude(extrude_depth)

# Second smaller square on top of the first square
# Align bottom right of the second square with the top right of the first square
second_square = first_square.faces(">Z").workplane() \
    .transformed(offset=(0, small_square_side / 2, 0)) \
    .rect(small_square_side, small_square_side).extrude(extrude_depth)

# Merge all parts into a single solid object
result = base.union(first_square).union(second_square)

# Export the final model to STL
result.val().exportStl("Refine_V_2.stl")
