
import cadquery as cq

length = 100.0  # Length of the base rectangle
width = 20.0    # Width of the base rectangle
thickness = 2.0 # Thickness of the extrusion

# Define the correct cutout size as exactly 1/4th the length of the original rectangle
cutout_length = length / 4.0
cutout_width = width / 2.0  # Half the width as per instructions from the description

# Create the base rectangle and extrude it
result = (
    cq.Workplane("XY")
    .rect(length, width)
    .extrude(thickness)
)

# Position of the cutout towards the bottom right of the rectangle
# Assuming the bottom side is along the X-axis (length) of the rectangle
cutout_position_x = length - cutout_length - 5  # Adjust the 5 unit border to position the cutout
cutout_position_y = -width / 2 + cutout_width / 2  # Centering the cutout in width towards the bottom

# Create the sketch on the top face, and cut the extruded rectangle appropriately
result = (
    result.faces(">Z")  # Working on the top face of the extruded rectangle
    .workplane(centerOption="CenterOfMass")
    .rect(cutout_length, cutout_width)
    .translate((cutout_position_x, cutout_position_y, 0))
    .cutThruAll()
)

# Saving the resulting model to an STL file
result.val().exportStl("Refine_V_2.stl")
