
import cadquery as cq

# Define dimensions
height = 5
main_length = 20
main_width = 10
tab_width = 2
tab_length = 5
hole_diameter = 6

# Create the main rectangular body
base = cq.Workplane("XY").rect(main_length, main_width).extrude(height)

# Add the tabs to resemble puzzle piece connectors
with_tab = (base.faces(">Y").workplane(centerOption="CenterOfBoundBox")
           .rect(tab_length, tab_width).extrude(height, combine=True)
            .faces("<Y").workplane(centerOption="CenterOfBoundBox")
            .rect(tab_length, tab_width).extrude(height, combine=True))

# Add circular hole in the center
final_result = with_tab.faces(">Z").workplane().hole(hole_diameter)

# Export to STL
final_result.val().exportStl("Refine_V_1.stl")
